﻿/*
VERSION:		1.0

USAGE:
	#include "writeXmlAsync.as"
	myXml = new XML();
	convert_vow = writeXmlAsync( myData, myXml );
	convert_vow.then( someFunc );
	
WHAT IS THIS:
	This is a performance-sensitive version of writeXml()
	Both writeXml() and writeXmlAsync() convert an artbitrary object and all of its children into XML data
	
NOTE:
	Everything is stored inside a <data> tag.
*/


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// XML Writing function
writeXmlAsync = function( targetObject, targetXml, rootName )
{
	#include "VOW.as"
	var uid = Math.floor(Math.random()*9999);
	trace(">>> writeXmlAsync() <"+uid+">");
	
	// Resolve optional parameters
	var rootName = (rootName) ? rootName : "data";
	
	// performance manager
	var startTime = getTimer();
	var delayThresh = 200;		// milliseconds
	var checkPerformance = function()
	{
		var uid = Math.floor(Math.random()*9999);
		trace(">>> checkPerformance() <"+uid+">");
		var vow;	// defined later
		
		var endTime = getTimer();
		var delay = endTime -startTime;
		//if( delay > delayThresh )
		if( true )
		{// if:  too much time has passed
			startTime = endTime;
			//vow = VOW.firstWait(34);
			vow = VOW.make();
			VOW.firstWait(5000)
				.then( function(){
					trace("<<< scanObject() <"+uid+"> done");
					vow.keep();
				});
		}// if:  too much time has passed
		else
		{// if:  there's still more time
			trace("<<< checkPerformance <"+uid+"> done");
			vow = VOW.make().keep();
		}// if:  there's still more time
		
		return vow.promise;
	}// checkPerformance();
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// private functions
	var scanObject = function( parentData, targetPath:XMLNode )
	{
		trace("");
		trace("");
		trace("");
		var uid = Math.floor(Math.random()*9999);
		trace("scanObject() <"+uid+">");
		trace("sourceData:  "+parentData);
		trace("targetPath:  "+targetPath);
		trace("");
		
		// scan_vow  (inherited from child function:  writeNextNode()
		
		// make a list of all the children within the current object
		var childList = [];
		for (var childName in parentData)
			childList.push(childName);
		
		
		
		// write attributes
		trace("- Writing attributes -");
		for (var cl=0; cl<childList.length; cl++)
		{
			var childName,
					childPath,
					childType;
			
			childName = childList[cl];
			trace("childName:  "+childName);
			childPath = parentData[childName];
			trace("childPath:  "+childPath);
			
			var targetPath2:XMLNode = targetPath;		// XML target, can be altered if this is an array
			var childName2 = childName;						// variable name, can be altered if this is an array
			
			if ( typeof( childPath ) == "object")
			{
				//trace("childPath.length:  "+childPath.length);
				if (childPath.length == undefined)
				{// if:  object
					// this is an object
					childType = "object"
				}// if:  object
				else
				{// if:  array
					// this is an array
					childType = "array";
				}// if:  array
			}// if:  some kind of "object"
			else
			{// if:  variable
				// this is a regular variable
				childType = "variable";
			}// if:  variable
			trace("childType:  "+childType);
			
			// write variables
			// // ignore all other types of data  (objects, arrays)
			if ( childType == "variable")
			{
				// store variable type
				// // bol
				if( typeof(childPath) == "boolean" ){
					childPath = "bol_"+String(childPath);
				}// if:  boolean
				// // num
				else if( typeof(childPath) == "number" ){
					childPath = "num_"+String(childPath);
				}// if:  number
				// // str
				else if( typeof(childPath) == "string" ){
					childPath = "str_"+String(childPath);
				}// if:  string
				
				// if the name is a number, then create a node for this array element
				if ( isNaN( Number(childName)) == false )
				{
					trace(childName+" is a number.");
					// childName is a number, therefore it as an array element
					// add element node  &  set targetPath2 to this new node (for attribute-writing)
					delete targetPath2;
					var targetPath2:XMLNode = addNode( childName, targetPath );
					childName2 = "value";
					addAttr( targetPath2, "xmlType", "variable" );
				}// if:  number
				// write the current variable as an attribute
				addAttr( targetPath2, childName2, childPath );
			}// if:  variable
		}// for:  each child
		trace("");
		
		
		
		// write nodes
		trace("- Writing nodes -");
		var writeThisNode = function( childName )
		{
			var uid = Math.floor(Math.random()*9999);
			trace(">>> writeThisNode() <"+uid+">");
			var writeThisNode_vow = VOW.make();
			
			var childPath,
					childType;
			
			trace("childName:  "+childName);
			childPath = parentData[childName];
			trace("childPath:  "+childPath);
			
			childType = "";
			if ( typeof( childPath ) == "object")
			{
				//trace("childPath.length:  "+childPath.length);
				if (childPath.length == undefined)
				{
					// this is an object
					childType = "object"
				}// if:  object
				else
				{// if:  array
					// this is an array
					childType = "array";
				}// if:  array
			}// if:  dome kind of "object"
			else
			{// if:  variable
				// this is a regular variable
				childType = "variable";
			}// if:  variable
			trace("childType:  "+childType);
			
			
			// write objects, arrays, variable elements
			// // ignore regular variables  (not array elements)
			if ( childType == "variable" )
			{
				// if this child is a variable, then there's nothing more to do, so continue
				writeThisNode_vow.keep();
				trace("<<< writeThisNode() <"+uid+"> done");
			}// if:  variable
			
			if ( childType == "object" )
			{
				var newNode:XMLNode = addNode( childName, targetPath );
				addAttr( newNode, "xmlType", "object" );
				//writeThisNode_vow = scanObject( childPath, newNode );
				writeThisNode_vow = VOW.make();
				scanObject( childPath, newNode )
					.then( function(){
						trace("<<< writeThisNode() <"+uid+"> done");
						writeThisNode_vow.keep();
					});
			}// if:  object
			
			if ( childType == "array" )
			{
				// create array node
				var newNode:XMLNode = addNode( childName, targetPath );
				addAttr( newNode, "xmlType", "array" );
				//writeThisNode_vow = scanObject( childPath, newNode );
				writeThisNode_vow = VOW.make();
				scanObject( childPath, newNode )
					.then( function(){
						trace("<<< writeThisNode() <"+uid+"> done");
						writeThisNode_vow.keep();
					});
			}// if:  array
			
			return writeThisNode_vow.promise;
		}// writeThisNode()
		
		
		
		var cIndex = 0;
		var writeNextNode = function()
		{
			var uid = Math.floor(Math.random()*9999);
			trace(">>> writeNextNode() <"+uid+">  "+cIndex+" out of "+childList.length);
			var writeNextNode_vow = VOW.make();
			
			if( cIndex < childList.length )
			{// if:  still more children to convert
				var childName = childList[cIndex];
				cIndex++;
				
				var callWriteThisNode = function(){
					return writeThisNode( childName );
				}// callWriteThisNode()
				
				checkPerformance()
					.then( callWriteThisNode )
					.then( writeNextNode )
					.then( function(){
						trace("<<< writeNextNode <"+uid+"> done");
						writeNextNode_vow.keep();
					} );
				
				/*
				writeThisNode( childName )
					.then( checkPerformance )
					.then( writeNextNode )
					.then( function(){
						trace("<<< writeNextNode <"+uid+"> done");
						writeNextNode_vow.keep();
					} );
				*/
			}// if:  still more children to convert
			else
			{// if:  converted all children
				trace("<<< writeNextNode <"+uid+"> done");
				writeNextNode_vow.keep();
			}// if:  converted all children
			
			return writeNextNode_vow.promise;
		}// writeNextNode()
		
		
		//var scan_vow = writeNextNode();
		var scan_vow = VOW.make();
		writeNextNode()
			.then( function(){
				trace("<<< scanObject() <"+uid+"> done");
				scan_vow.keep();
			});
		
		/*
		delete childName;
		delete childPath;
		delete childType;
		*/
		return scan_vow.promise;
	}// scanObject()
	
	
	
	var addNode = function( newNodeName:String, xmlPath:XMLNode )
	{
		trace("\tADDNODE()");
		trace("\t\tnewNodeName:  "+newNodeName);
		trace("\t\txmlPath:  "+xmlPath);
		var tempXml = new XML();
		var newNode:XMLNode = tempXml.createElement(newNodeName);
		delete tempXml;
		xmlPath.appendChild(newNode);
		var newXmlPath:XMLNode = xmlPath.lastChild;
		trace("\t\tReturn new node:   "+newXmlPath);
	
		return newXmlPath;
	}// addNode()
	
	var addAttr = function( targetNode, newVariable, newValue )
	{
		targetNode.attributes[newVariable] = newValue;
	}// addAttr()
	// END:	private functions
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	
	
	
	
	
	
	// Manually create an "object" type of node in the xml, to store loose variables
	var xmlParentPath:XMLNode = targetXml;
	trace("object:   data:  create node");
	var newXmlTarget:XMLNode = addNode(rootName, xmlParentPath);
	addAttr( newXmlTarget, "xmlType", "object" );
	
	//var convert_vow = scanObject( targetObject, newXmlTarget );
	convert_vow = VOW.make();
	scanObject( targetObject, newXmlTarget )
		.then( function(){
			trace("<<< writeXmlAsync() <"+uid+"> done");
			convert_vow.keep();
		});
	
	// enable then() after this conversion finishes
	return convert_vow.promise;
}// writeXmlAsync()